"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface

from enum import Enum

"""
As far as I can tell, this isn't in the
Meshtastic Library
"""
class BLEPINSetting(Enum):
    Random = 0
    Fixed = 1
    Disabled = 2

interface = meshtastic.serial_interface.SerialInterface()
node = interface.getNode('^local')

print(node.localConfig.network)
#print(node.localConfig.bluetooth)

print ("Bluetooth Enabled: " + str(node.localConfig.bluetooth.enabled))
print ("PIN Mode: " + str(BLEPINSetting(node.localConfig.bluetooth.mode).name))
print ("NTP Server: " + str(node.localConfig.bluetooth.fixed_pin))

interface.close()
